/*
Module : CSecHandle.h
Purpose: Provides a RAII C++ wrapper class for a "SecHandle"
History: PJN / 21-12-2020 1. Initial Public release.

Copyright (c) 2020 - 2023 by PJ Naughter (Web: www.naughter.com, Email: pjna@naughter.com)

All rights reserved.

Copyright / Usage Details:

You are allowed to include the source code in any product (commercial, shareware, freeware or otherwise)
when your product is released in binary form. You are allowed to modify the source code in any way you want
except you cannot modify the copyright details at the top of each module. If you want to distribute source
code with your application, then you are only allowed to distribute versions released by the author. This is
to maintain a single distribution point for the source code.

*/


/////////////////////////// Macros / Defines //////////////////////////////////

#if _MSC_VER > 1000
#pragma once
#endif //#if _MSC_VER > 1000

#ifndef __CSECHANDLE_H__
#define __CSECHANDLE_H__

#ifndef CSECHANDLE_EXT_CLASS
#define CSECHANDLE_EXT_CLASS
#endif //#ifndef CSECHANDLE_EXT_CLASS


/////////////////////////// Classes ///////////////////////////////////////////

class CSecHandle
{
public:
//Constructors / Destructors
  CSecHandle() noexcept : m_Handle{}
  {
  }
  CSecHandle(_In_ const CSecHandle&) = delete;
  CSecHandle(CSecHandle&& handle) noexcept
  {
    m_Handle.dwUpper = handle.m_Handle.dwUpper;
    m_Handle.dwLower = handle.m_Handle.dwLower;
  }
  ~CSecHandle()
  {
    if (valid())
    {
      DeleteSecurityContext(&m_Handle);
      m_Handle.dwLower = 0;
      m_Handle.dwUpper = 0;
    }
  }

//Methods
  CSecHandle& operator=(_In_ const CSecHandle&) = delete;

  CSecHandle& operator=(CSecHandle&& handle) noexcept
  {
    m_Handle.dwUpper = handle.m_Handle.dwUpper;
    m_Handle.dwLower = handle.m_Handle.dwLower;
    handle.m_Handle.dwUpper = 0;
    handle.m_Handle.dwLower = 0;
    return *this;
  }

  [[nodiscard]] bool valid() const noexcept
  {
    return (m_Handle.dwLower != 0) || (m_Handle.dwUpper != 0);
  }

  operator SecHandle() noexcept
  {
    return m_Handle;
  }

//Member variables
  SecHandle m_Handle;
};


#endif //#define __CSECHANDLE_H__
