/*
Module : CPPCThreadPoolTLS.h
Purpose: Provides a compilation unit for declaration of the thread_local variables used by the CPPCThreadPool framework
History: PJN / 13-04-2021 1. This new cpp module in the CPPCThreadPool framework is required to avoid linker errors 
                          where the two thread_local member variables declared in CPPCThreadPool.h 
                          (CThreadPool::_LocalQueue & CThreadPool::_ThreadIndex) can be defined in multiple compilation
                          units if the CPPCThreadPool.h header is included by your source code multiple times.
         PJN / 13-02-2022 1. Updated the code to use C++ uniform initialization for all variable declarations

Copyright (c) 2021 - 2023 by PJ Naughter (Web: www.naughter.com, Email: pjna@naughter.com)

All rights reserved.

Copyright / Usage Details:

You are allowed to include the source code in any product (commercial, shareware, freeware or otherwise)
when your product is released in binary form. You are allowed to modify the source code in any way you want
except you cannot modify the copyright details at the top of each module. If you want to distribute source
code with your application, then you are only allowed to distribute versions released by the author. This is
to maintain a single distribution point for the source code.

*/


/////////////////////////// Includes //////////////////////////////////////////

#include "stdafx.h"
#include "CPPCThreadPool.h"


/////////////////////////// Implementation ////////////////////////////////////

/// @brief the thread local queue pointer for the current worker thread in the thread pool
thread_local std::deque<CppConcurrency::CFunctionWrapper>* CppConcurrency::CThreadPool::_LocalQueue{nullptr};

/// @brief the thread local thread index for the current worker thread in the thread pool
thread_local size_t CppConcurrency::CThreadPool::_ThreadIndex{0};
