/*
Module : CSecHandle.h
Purpose: Provides a RAII C++ wrapper class for a "CredHandle"
History: PJN / 21-12-2020 1. Initial Public release.

Copyright (c) 2020 - 2023 by PJ Naughter (Web: www.naughter.com, Email: pjna@naughter.com)

All rights reserved.

Copyright / Usage Details:

You are allowed to include the source code in any product (commercial, shareware, freeware or otherwise)
when your product is released in binary form. You are allowed to modify the source code in any way you want
except you cannot modify the copyright details at the top of each module. If you want to distribute source
code with your application, then you are only allowed to distribute versions released by the author. This is
to maintain a single distribution point for the source code.

*/


/////////////////////////// Macros / Defines //////////////////////////////////

#if _MSC_VER > 1000
#pragma once
#endif //#if _MSC_VER > 1000

#ifndef __CCREDHANDLE_H__
#define __CCREDHANDLE_H__

#ifndef CCREDHANDLE_EXT_CLASS
#define CCREDHANDLE_EXT_CLASS
#endif //#ifndef CCREDHANDLE_EXT_CLASS


/////////////////////////// Classes ///////////////////////////////////////////

class CCredHandle
{
public:
//Constructors / Destructors
  CCredHandle() noexcept : m_Handle{}
  {
  }
  CCredHandle(_In_ const CCredHandle&) = delete;
  CCredHandle(CCredHandle&& handle) noexcept
  {
    m_Handle.dwUpper = handle.m_Handle.dwUpper;
    m_Handle.dwLower = handle.m_Handle.dwLower;
  }
  ~CCredHandle()
  {
    if (valid())
    {
      FreeCredentialsHandle(&m_Handle);
      m_Handle.dwLower = 0;
      m_Handle.dwUpper = 0;
    }
  }

//Methods
  CCredHandle& operator=(_In_ const CCredHandle&) = delete;

  CCredHandle& operator=(CCredHandle&& handle) noexcept
  {
    m_Handle.dwUpper = handle.m_Handle.dwUpper;
    m_Handle.dwLower = handle.m_Handle.dwLower;
    handle.m_Handle.dwUpper = 0;
    handle.m_Handle.dwLower = 0;
    return *this;
  }

  [[nodiscard]] bool valid() const noexcept
  {
    return (m_Handle.dwLower != 0) || (m_Handle.dwUpper != 0);
  }

  operator CredHandle() noexcept
  {
    return m_Handle;
  }

//Member variables
  CredHandle m_Handle;
};

#endif //#define __CCREDHANDLE_H__
