//////////////////////////////// Includes /////////////////////////////////////

#include "stdafx.h"
#include "TemperWrappers.h"


//////////////////////////////// Macros / Defines /////////////////////////////

constexpr const std::array<BYTE, 8> g_byIniReport1{ 0x01, 0x82, 0x77, 0x01, 0x00, 0x00, 0x00, 0x00 }; //The first init string for the 0xC45 / 0x7401 device
constexpr const std::array<BYTE, 8> g_byIniReport2{ 0x01, 0x86, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00 }; //This seems to be a VersionCmd for the TemperHum variant of the Temper device ala http://unclassified.software/files/source/TEMPer.cs
constexpr const std::array<BYTE, 8> g_byTemperatureReport{ 0x01, 0x80, 0x33, 0x01, 0x00, 0x00, 0x00, 0x00 }; //The command for a temperature report for the 0xC45 / 0x7401 device


//////////////////////////////// Implementation ///////////////////////////////

int _tmain()
{
  _tprintf(_T("Enumerating HID devices with a Vendor id of 0xC45 on this computer\n"));
  HID::StringArray deviceNames;
  bool bSuccess{HID::CDevice::EnumerateDevices(0xC45, deviceNames)}; //NOLINT(clang-analyzer-deadcode.DeadStores, clang-diagnostic-unused-but-set-variable)
#pragma warning(suppress: 26477)
  ATLASSERT(bSuccess);
  for (const auto& device : deviceNames)
    _tprintf(_T(" Found device path of %s\n"), device.c_str());

  _tprintf(_T("Enumerating Temper HID devices on this computer\n"));
  bSuccess = HID::CTemperDevice::Enumerate(deviceNames); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
  ATLASSERT(bSuccess);
  HID::String sDevicePath;
  for (const auto& device : deviceNames)
  {
#pragma warning(suppress: 26489)
    if (device.find(_T("mi_01")) != HID::String::npos) //Look for the interface where bInterfaceNumber from the interface descriptor is 1. The 0 interface is the emulated keyboard interface of the Temper device
    {
#pragma warning(suppress: 26486)
#pragma warning(suppress: 26489)
      sDevicePath = device;
#pragma warning(suppress: 26489)
      _tprintf(_T(" Found device path of %s\n"), device.c_str());
    }
  }
  if (sDevicePath.length() == 0)
  {
    _tprintf(_T(" No Temper devices found\n"));
    return 1;
  }

  //Open up the HID temper device
  HID::CTemperDevice device;

  bSuccess = device.Open(sDevicePath.c_str()); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
  ATLASSERT(bSuccess);

  std::vector<wchar_t> wszProduct{127, std::allocator<wchar_t>{}};
#pragma warning(suppress: 26472)
  if (device.GetProductString(wszProduct.data(), static_cast<ULONG>(wszProduct.size())))
    wprintf(L"Product: %s\n", wszProduct.data());
  std::vector<wchar_t> wszManufacturer{127, std::allocator<wchar_t>{}};
#pragma warning(suppress: 26472)
  if (device.GetManufacturerString(wszManufacturer.data(), static_cast<ULONG>(wszManufacturer.size())))
    wprintf(L"Manufacturer: %s\n", wszManufacturer.data());
  std::vector<wchar_t> wszSerialNumber{127, std::allocator<wchar_t>{}};
#pragma warning(suppress: 26472)
  if (device.GetSerialNumberString(wszSerialNumber.data(), static_cast<ULONG>(wszSerialNumber.size())))
    wprintf(L"Serial Number: %s\n", wszSerialNumber.data());

  //Get the report caps on the interface
  PHIDP_PREPARSED_DATA hpd{nullptr};
  BOOLEAN bool2{device.GetPreparsedData(&hpd)}; //NOLINT(clang-analyzer-deadcode.DeadStores, clang-diagnostic-unused-but-set-variable)
#pragma warning(suppress: 26477)
  ATLASSUME(bool2);
  HIDP_CAPS capsBulk{};
  #pragma warning(suppress: 6102)
  const NTSTATUS status{HidP_GetCaps(hpd, &capsBulk)};
#pragma warning(suppress: 26477)
  ATLASSUME(status == HIDP_STATUS_SUCCESS);
  UNREFERENCED_PARAMETER(status);
  HidD_FreePreparsedData(hpd);

  HIDD_ATTRIBUTES attributes{};
  attributes.Size = sizeof(attributes);
  bool2 = device.GetAttributes(&attributes); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
  ATLASSERT(bool2);
  bool2 = device.FlushQueue(); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
  ATLASSERT(bool2);
  ULONG nBuffers{0};
  if (device.GetNumInputBuffers(&nBuffers))
  {
    bool2 = device.SetNumInputBuffers(nBuffers); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
    ATLASSERT(bool2);
  }
  std::vector<wchar_t> wszIndexedString{127, std::allocator<wchar_t>{}};
#pragma warning(suppress: 26472)
  bool2 = device.GetIndexedString(1, wszIndexedString.data(), static_cast<ULONG>(wszIndexedString.size())); //NOLINT(clang-analyzer-deadcode.DeadStores)

  //Write out the "ini1" report to the interface
  _tprintf(_T("Sending ini1 report to the device. Data: "));
  for (const auto& data : g_byIniReport1)
#pragma warning(suppress: 26472)
    _tprintf(_T("%02X "), static_cast<int>(data));
  _tprintf(_T("\n"));
#pragma warning(suppress: 26472)
  bSuccess = device.WriteOutputReport(g_byIniReport1.data(), static_cast<DWORD>(g_byIniReport1.size())); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
  ATLASSERT(bSuccess);
  std::vector<BYTE> inputReport{9, std::allocator<BYTE>{}};
  bSuccess = device.ReadInputReport(inputReport.data(), 9, nullptr); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
  ATLASSUME(bSuccess);
  _tprintf(_T(" Reading dummy ini report from the device. Data: "));
  for (const auto& data : inputReport)
#pragma warning(suppress: 26472)
    _tprintf(_T("%02X "), static_cast<int>(data));
  _tprintf(_T("\n"));

  //Write out the "ini2" report to the interface
  _tprintf(_T("Sending ini2 report to the device. Data: "));
  for (const auto& data : g_byIniReport2)
#pragma warning(suppress: 26446 26472)
    _tprintf(_T("%02X "), static_cast<int>(data));
  _tprintf(_T("\n"));
#pragma warning(suppress: 26472)
  bSuccess = device.WriteOutputReport(g_byIniReport2.data(), static_cast<DWORD>(g_byIniReport2.size())); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
  ATLASSERT(bSuccess);
  inputReport.assign(9, 0);
#pragma warning(suppress: 26472)
  bSuccess = device.ReadInputReport(inputReport.data(), static_cast<DWORD>(inputReport.size()), nullptr); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
  ATLASSUME(bSuccess);
  _tprintf(_T(" Reading dummy ini report from the device. Data: "));
  for (const auto& data : inputReport)
#pragma warning(suppress: 26472)
    _tprintf(_T("%02X "), static_cast<int>(data));
  _tprintf(_T("\n"));

  //Clear out garbage from the data by doing a couple of requests for temperature
  _tprintf(_T("Sending dummy temperature report to the device. Data: "));
  for (const auto& data : g_byTemperatureReport)
#pragma warning(suppress: 26472)
    _tprintf(_T("%02X "), static_cast<int>(data));
  _tprintf(_T("\n"));
#pragma warning(suppress: 26472)
  bSuccess = device.WriteOutputReport(g_byTemperatureReport.data(), static_cast<DWORD>(g_byTemperatureReport.size())); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
  ATLASSERT(bSuccess);
  _tprintf(_T(" Reading dummy temperature report from the device. Data: "));
  inputReport.assign(9, 0);
#pragma warning(suppress: 26472)
  bSuccess = device.ReadInputReport(inputReport.data(), static_cast<DWORD>(inputReport.size()), nullptr); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
  ATLASSUME(bSuccess);
  for (const auto& data : inputReport)
#pragma warning(suppress: 26472)
    _tprintf(_T("%02X "), static_cast<int>(data));
  _tprintf(_T("\n"));
  _tprintf(_T("Sending dummy temperature report to the device. Data: "));
  for (const auto& data : g_byTemperatureReport)
#pragma warning(suppress: 26472)
    _tprintf(_T("%02X "), static_cast<int>(data));
  _tprintf(_T("\n"));
#pragma warning(suppress: 26472)
  bSuccess = device.WriteOutputReport(g_byTemperatureReport.data(), static_cast<DWORD>(g_byTemperatureReport.size())); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
  ATLASSERT(bSuccess);
  _tprintf(_T(" Reading dummy temperature report from the device. Data: "));
  inputReport.assign(9, 0);
#pragma warning(suppress: 26472)
  bSuccess = device.ReadInputReport(inputReport.data(), static_cast<DWORD>(inputReport.size()), nullptr); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
  ATLASSUME(bSuccess);
  for (const auto& data : inputReport)
#pragma warning(suppress: 26472)
    _tprintf(_T("%02X "), static_cast<int>(data));
  _tprintf(_T("\n"));

  //Read the temperature in a loop
  while (true)
  {
    _tprintf(_T("Sending temperature report to the device\n"));
#pragma warning(suppress: 26472)
    bSuccess = device.WriteOutputReport(g_byTemperatureReport.data(), static_cast<DWORD>(g_byTemperatureReport.size())); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
    ATLASSERT(bSuccess);

    _tprintf(_T(" Reading temperature report from the device. Data: "));
    inputReport.assign(9, 0);
#pragma warning(suppress: 26472)
    bSuccess = device.ReadInputReport(inputReport, nullptr); //NOLINT(clang-analyzer-deadcode.DeadStores)
#pragma warning(suppress: 26477)
    ATLASSUME(bSuccess);
    for (const auto& data : inputReport)
#pragma warning(suppress: 26472)
      _tprintf(_T("%02X "), static_cast<int>(data));
    _tprintf(_T("\n"));
    const double fCelsius{HID::CTemperDevice::GetTemperatureFromInputReport(inputReport)};
#pragma warning(suppress: 26477)
    ATLASSUME(bSuccess);
    const double fFahrenheit{fCelsius * 1.8 + 32.0};
    _tprintf(_T("  Temperature: %.2f Celsius, %.2f Fahrenheit\n"), fCelsius, fFahrenheit);

    //Wait for a second before we loop around
    Sleep(1000);
  }

  return 0;
}
